
(* Background work for PMC communication, should be called once and only once per PLC cycle *)
FUNCTION_BLOCK PMC_AutoRefresh
	IF Enable = TRUE THEN
		(*Read current frame count*)
		memcpy(pDest := ADR(FrmCount),pSrc := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_FRMC_OFFSET,length := 1);
	
		(*Tick up frame count*)
		FrmCount := FrmCount + 1;
		memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_FRMC_OFFSET,pSrc := ADR(FrmCount),length := 1);	
	
		(*Update .PMCDB with newest xbot muxed position*)
		(*read muxed xbot ID*)
		memcpy(pDest := ADR(curXID),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET,length := 1);
	
		(*Read and update the event IDs*)
		memcpy(pDest := ADR(EventID1),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_EVENT_OFFSET,length := 2);
		memcpy(pDest := ADR(EventID2),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_EVENT_OFFSET + 3,length := 2);	
		IF(EventID1 > 0)THEN
			memcpy(pDest := ADR(PM_Controller.EventMgmt.EventCode[EventID1]),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_EVENT_OFFSET + 2,length := 1);
			PM_Controller.EventMgmt.ExecutingEventID[EventID1] := FALSE;
		END_IF; 
		IF(EventID2 > 0)THEN
			memcpy(pDest := ADR(PM_Controller.EventMgmt.EventCode[EventID2]),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_EVENT_OFFSET + 5,length := 1);
			PM_Controller.EventMgmt.ExecutingEventID[EventID2] := FALSE;
		END_IF; 
	
		(*if current xbotID is valid, update .PMCDB with newest xbot muxed position*)
		IF curXID > 0 AND curXID <= 256 THEN
			(*read X position from frame*)
			memcpy(pDest := ADR(PM_Controller.PMCDB.PosX[curXID - 1] ),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET + 4,length := 4);
		
			(*read Y position from frame*)
			memcpy(pDest := ADR(PM_Controller.PMCDB.PosY[curXID - 1] ),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET + 8,length := 4);
		
			(*read Z position from frame*)
			memcpy(pDest := ADR(PM_Controller.PMCDB.PosZ[curXID - 1] ),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET + 12,length := 4);
		
			(*read RX position from frame*)
			memcpy(pDest := ADR(PM_Controller.PMCDB.PosRx[curXID - 1] ),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET + 16,length := 4);
		
			(*read RY position from frame*)
			memcpy(pDest := ADR(PM_Controller.PMCDB.PosRy[curXID - 1] ),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET + 20,length := 4);
		
			(*read RZ position from frame*)
			memcpy(pDest := ADR(PM_Controller.PMCDB.PosRz[curXID - 1] ),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_MUX_OFFSET + 24,length := 4);
		
			Valid := TRUE;
		ELSE
			Valid := FALSE;
		END_IF;
	ELSE
		Valid := FALSE;
	END_IF;
END_FUNCTION_BLOCK
